// SampleGrabber.cpp: implementation of the CSampleGrabber class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "SampleGrabber.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

VOID CSampleGrabber::SC_DEBUG( CHAR * fmt, ... )
{
	CHAR pszDebugDumpMessage[ MAX_PATH ] = "[SDK.SG] [00000000] ";

	va_list marker;

	va_start( marker, fmt );

	StringCbPrintfA( pszDebugDumpMessage + 8 + 1, sizeof(pszDebugDumpMessage), "[%08X] ", this );

	StringCbVPrintfA( pszDebugDumpMessage + 8 + 1 + 10 + 1, sizeof(pszDebugDumpMessage), fmt, marker );

	va_end( marker );

	StringCbCatA( pszDebugDumpMessage, sizeof(pszDebugDumpMessage), "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

CSampleGrabber::CSampleGrabber()
{
//	SC_DEBUG( "CSampleGrabber::CSampleGrabber()" );

	m_pBufferCB = NULL;

	m_pUserData = NULL;
}

CSampleGrabber::~CSampleGrabber()
{
//	SC_DEBUG( "CSampleGrabber::~CSampleGrabber()" );

	m_pBufferCB = NULL;

	m_pUserData = NULL;
}

STDMETHODIMP CSampleGrabber::BufferCB( double dSampleTime, BYTE * pBuffer, LONG nBufferLen ) 
{
	BOOL returns = FALSE;

	if( 0 == nBufferLen ) return S_OK;

	if( NULL != m_pBufferCB ) { returns = (*m_pBufferCB)( dSampleTime, pBuffer, nBufferLen, TRUE, m_pUserData ); }

//	SC_DEBUG( "CSampleGrabber::BufferCB( %f  %d )", dSampleTime, nBufferLen );

	return S_OK;
}

STDMETHODIMP CSampleGrabber::SampleCB( double dSampleTime, IMediaSample * pSample ) 
{ 
	BYTE * pBuffer = NULL; pSample->GetPointer( &pBuffer );
		
	LONG   nBufferLen = pSample->GetActualDataLength();

	BOOL   bIsKeyFrame = TRUE;

	BOOL   returns = FALSE;
	
	if( 0 == nBufferLen ) { return S_OK; } // NOTE!! IT IS AN ERROR FRAME.

	if( m_nDeviceType == 0x00000002 ) {

		if( pBuffer ) {

			DWORD * pStreamHeader = (DWORD *)(pBuffer + nBufferLen); // [STREAM PAYLOAD] + [4 BYTES HEADER]

			bIsKeyFrame = (pStreamHeader[ 0 ] & 0x00C00000) ? (FALSE) : (TRUE);
		}
	}
	if( m_pBufferCB ) {
		
		returns = (*m_pBufferCB)( dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, m_pUserData );

		if( returns == FALSE ) { 
			
			pSample->SetActualDataLength( 0 ); // NOTE!! UPPER SOFTWARE NEED TO DROP THIS FRAME.
		}
	}
//	SC_DEBUG( "CSampleGrabber::SampleCB( %f  %d )", dSampleTime, nBufferLen );

	return S_OK;
}
